﻿/*
version:		2.0
*/

/* 
- DESCRIPTION -
This loads a text file containing a list of names (including spaces and punctuation),
and puts all the names into an array.



- EXAMPLE -
	The text file must start with "data=",  like so:
data=
name1
name2
name3



- USAGE -
readFile( fileName, destinationArray, sendFunctionsTo );

fileName:					A text string, specifying the text file you want to load.  (include the path)
destinationArray:		The array you want to populate with names.
sendFunctionsTo:		The location of your functions.  

The code will call the following functions inside that location:
	onLoadStart()			Called when loading is attempted.
	onLoadError()			Called if the file was not found.
	onLoadInit(array)		Called after loading & array-making are complete.  The completed array is passed to this function.
*/





function readFile( filename:String, dest_array:Array, callTarget )
{
	// create an object to store parameters across functions
	this.newData_obj = new Object();
	this.newData_obj.dest_array;		// reference to new array
	this.newData_obj.callTarget;			// reference for callback functions
	// Store parameters in the movieclip,  to preserve them across function calls
	newData_obj.dest_array = dest_array;		// store data destination
	newData_obj.callTarget = callTarget;			// store callback target
	//newData_obj.dest_array = new Array();		// clear old data
	//newData_obj.data = undefined;		// clear old data
	
	this.myLoader = new LoadVars();
	// load the file
	this.myLoader.onLoad = function( success:Boolean )
	{
		if (success)
		{
			// Loaded the file
			parseLoadedData( this.data );
		}else{
			// File not found
			newData_obj.callTarget.onLoadError();
		}
	}
	
	myLoader.load( filename );
	//loadVariables(filename, newData_obj);

	newData_obj.callTarget.onLoadStart();		// Callback:  Loading has begun
	
	//repeatCheckLoad = setInterval(checkLoad, 100);		// Periodically check if loading has finished
}



function parseLoadedData( newData:String )
{
	var readCharacter = "";
	var newName = "";
	for ( var i = 0; i < newData.length; i++)
	{
		readCharacter = newData.charAt(i);
		if (newData.charCodeAt(i) == 10 )
		{
			// It's the end of this line, so add the name
			if (newName != "")
			{
				newData_obj.dest_array.push( newName );
			}
			newName = "";
		}
		else if (newData.charCodeAt(i) == 13 )
		{
			// extra carriage return code, so ignore it
		}
		else
		{
			// assume this character is part of the current name, so add it
			newName += readCharacter;
		}// END if
	}// END for
	// if the file ends on something other than a carriage return, assume there's one more name to add

	// back up to look at the last character
	i--;
	if (newData.charCodeAt(i) != 13  &&  newData.charCodeAt(i) != 10 )
	{
		newData_obj.dest_array.push( newName );
	}
	
	// Output
	newData_obj.callTarget.onLoadInit( newData_obj.dest_array );
	
	// CLEAN-UP
	delete newData_obj;
	delete myLoader;
	/*
	delete this.onLoadStart;
	delete this.onLoadInit;
	delete this.onLoadError;
	*/
}